<?php
/**
 * Store Catalog PDF Download for WooCommerce Uninstall.
 *
 * Deletes the plugin options.
 *
 * @package WC_Store_Catalog_PDF_Download/Uninstaller
 * @since   1.0.0
 */

defined( 'WP_UNINSTALL_PLUGIN' ) || exit;

/*
 * Only remove ALL product and page data if WC_REMOVE_ALL_DATA constant is set to true in user's
 * wp-config.php. This is to prevent data loss when deleting the plugin from the backend
 * and to ensure only the site owner can perform this action.
 */
if ( defined( 'WC_REMOVE_ALL_DATA' ) && true === WC_REMOVE_ALL_DATA ) {
	// Remove the created folder.
	$upload_dir = wp_upload_dir();
	$pdf_path   = $upload_dir['basedir'] . '/woocommerce-store-catalog-pdf-download';

	if ( is_dir( $pdf_path ) ) {
		$files = glob( $pdf_path . '/*' );

		// Remove files.
		foreach ( $files as $file ) {
			if ( is_file( $file ) ) {
				wp_delete_file( $file );
			}
		}

		// Remove the directory.
		@rmdir( $pdf_path ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_rmdir, WordPress.PHP.NoSilencedErrors.Discouraged
	}
}
