<?php
/**
 * Template: PDF Layout Single HTML.
 *
 * @package WC_Store_Catalog_PDF_Download
 * @version 2.2.0
 */

defined( 'ABSPATH' ) || exit;

global $wc_posts;

?>

	<div class="single">
		<?php

		foreach ( $wc_posts as $post ) {

			// create the product object
			$product = wc_get_product( $post );

			$single_image_size = apply_filters( 'wc_store_catalog_pdf_download_single_image_size', array( 800, 9999, false ), $product );
			$product_image     = $product->get_image( $single_image_size );
			?>
			<?php do_action( 'wc_store_catalog_pdf_download_before_product', $product ); ?>

			<h2><a href="<?php echo esc_html( get_permalink( $product->get_id() ) ); ?>"><?php echo apply_filters( 'wc_store_catalog_pdf_download_show_product_title', $product->get_name(), $product ); ?></a></h2><br /><br />
			<p><a href="<?php echo esc_html( get_permalink( $product->get_id() ) ); ?>" class="single-image-link"><?php echo apply_filters( 'wc_store_catalog_pdf_download_show_product_image', has_post_thumbnail( $post ) ? $product_image : WC_Store_Catalog_PDF_Download_Ajax::get_placeholder_image( array() ), $product ); ?></a></p>

			<div class="clear"></div>

			<?php echo wp_kses_post( apply_filters( 'wc_store_catalog_pdf_download_show_product_price', $product->get_price_html() ) ); ?>

			<p class="description"><?php echo apply_filters( 'wc_store_catalog_pdf_download_description', $product->get_description(), $product ); ?></p>

			<?php apply_filters( 'wc_store_catalog_pdf_download_product_meta', include WC_Store_Catalog_PDF_Download_Ajax::get_product_meta_template( $product ) ); ?>

			<?php do_action( 'wc_store_catalog_pdf_download_product_attr', $product ); ?>

			<?php do_action( 'wc_store_catalog_pdf_download_after_product', $product ); ?>
			<?php
		}
		?>
	</div>
