<?php
/**
 * Template: PDF Layout Product Meta HTML.
 *
 * @package WC_Store_Catalog_PDF_Download
 * @version 2.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
* Template vars.
 *
 * @var $product WC_Product Product object.
 */
$sku       = $product->get_sku();
$cat_count = get_the_terms( $product->get_id(), 'product_cat' );
$cat_count = is_array( $cat_count ) ? count( $cat_count ) : 0;
$tag_count = get_the_terms( $product->get_id(), 'product_tag' );
$tag_count = is_array( $tag_count ) ? count( $tag_count ) : 0;

$categories = wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">' . _n( 'Category:', 'Categories:', $cat_count, 'woocommerce-store-catalog-pdf-download' ) . ' ', '.</span>' );
$tags       = wc_get_product_tag_list( $product->get_id(), ', ', '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', $tag_count, 'woocommerce-store-catalog-pdf-download' ) . ' ', '.</span>' );

?>
<div class="product-meta">

	<?php do_action( 'woocommerce_product_meta_start' ); ?>

	<?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>

		<span class="sku_wrapper"><?php esc_html_e( 'SKU:', 'woocommerce-store-catalog-pdf-download' ); ?> <span class="sku" itemprop="sku"><?php echo esc_html( $sku ? $sku : __( 'N/A', 'woocommerce-store-catalog-pdf-download' ) ); ?></span>.</span>

	<?php endif; ?>

	<?php echo $categories; ?>

	<?php echo $tags; ?>

	<?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>
