<?php
/**
 * Plugin utilities.
 *
 * @since 2.0.0
 */

namespace KoiLab\WC_Store_Catalog_PDF_Download\Utilities;

/**
 * Class Plugin_Utils.
 */
class Plugin_Utils {

	/**
	 * Cache the active plugins.
	 *
	 * @var array
	 */
	private static $active_plugins;

	/**
	 * Gets the active plugins.
	 *
	 * @since 2.0.0
	 * @deprecated 2.2.0
	 *
	 * @return array
	 */
	public static function get_active_plugins() {
		wc_deprecated_function( __FUNCTION__, '2.2.0' );

		if ( ! self::$active_plugins ) {
			self::$active_plugins = (array) get_option( 'active_plugins', array() );

			if ( is_multisite() ) {
				self::$active_plugins = array_merge( self::$active_plugins, get_site_option( 'active_sitewide_plugins', array() ) );
			}
		}

		return self::$active_plugins;
	}

	/**
	 * Gets if the plugin is active.
	 *
	 * @since 2.0.0
	 *
	 * @param string $plugin Base plugin path from plugins directory.
	 * @return bool
	 */
	public static function is_plugin_active( $plugin ) {
		if ( ! function_exists( 'is_plugin_active' ) ) {
			include_once ABSPATH . 'wp-admin/includes/plugin.php';
		}

		return is_plugin_active( $plugin );
	}

	/**
	 * Gets if the WooCommerce plugin is active.
	 *
	 * @since 2.0.0
	 *
	 * @return bool
	 */
	public static function is_woocommerce_active() {
		return self::is_plugin_active( 'woocommerce/woocommerce.php' );
	}
}
