<?php
/**
 * Admin View: Setting Status Report.
 *
 * @package WC_Store_Catalog_PDF_Download/Admin/Views
 * @since   2.2.0
 */

defined( 'ABSPATH' ) || exit;

use KoiLab\WC_Store_Catalog_PDF_Download\Admin\System_Status_Report;
?>
<table class="wc_status_table widefat" cellspacing="0" id="status">
	<thead>
		<tr>
			<th colspan="6" data-export-label="Store Catalog PDF Download">
				<h2><?php esc_html_e( 'Store Catalog PDF Download', 'woocommerce-store-catalog-pdf-download' ); ?><?php echo wc_help_tip( esc_html__( 'This section shows information about Store Catalog PDF Download for WooCommerce.', 'woocommerce-store-catalog-pdf-download' ) ); ?></h2>
			</th>
		</tr>
	</thead>
	<tbody>
		<tr>
			<td data-export-label="System Temp Directory"><?php esc_html_e( 'System Temp Directory', 'woocommerce-store-catalog-pdf-download' ); ?></td>
			<td class="help"></td>
			<td><?php echo esc_html( sys_get_temp_dir() ); ?></td>
		</tr>

		<tr>
			<?php
			$upload_dir = wp_upload_dir();
			$pdf_path   = $upload_dir['basedir'] . '/woocommerce-store-catalog-pdf-download/';
			?>
			<td data-export-label="Upload Directory"><?php esc_html_e( 'Upload Directory', 'woocommerce-store-catalog-pdf-download' ); ?></td>
			<td class="help"></td>
			<td><?php System_Status_Report::output_bool_html( file_exists( $pdf_path ) && is_writable( $pdf_path ), $pdf_path ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_is_writable ?></td>
		</tr>

		<tr>
			<td data-export-label="DOMDocument extension">DOMDocument extension</td>
			<td class="help"></td>
			<td><?php System_Status_Report::output_bool_html( extension_loaded( 'DOM' ), phpversion( 'DOM' ) ); ?></td>
		</tr>

		<tr>
			<td data-export-label="GD Library">GD Library</td>
			<td class="help"></td>
			<td><?php System_Status_Report::output_bool_html( extension_loaded( 'gd' ) && function_exists( 'gd_info' ) ); ?></td>
		</tr>

		<tr>
			<td data-export-label="MBString">MB String</td>
			<td class="help"></td>
			<td><?php System_Status_Report::output_bool_html( extension_loaded( 'mbstring' ) ); ?></td>
		</tr>

		<tr>
			<td data-export-label="URL fopen">Allow URL fopen</td>
			<td class="help"></td>
			<td><?php System_Status_Report::output_bool_html( ini_get( 'allow_url_fopen' ) ); ?></td>
		</tr>

		<tr>
			<td data-export-label="Template Overrides"><?php esc_html_e( 'Template Overrides', 'woocommerce-store-catalog-pdf-download' ); ?></td>
			<td class="help"></td>
			<td>
				<?php
				$stylesheet_dir = get_stylesheet_directory();
				$templates      = array(
					'pdf-layout-product-meta-html.php',
					'pdf-layout-list-html.php',
					'pdf-layout-grid-html.php',
					'pdf-layout-single-html.php',
					'pdf-layout-header-html.php',
					'pdf-layout-footer-html.php',
				);

				$theme      = wp_get_theme();
				$theme_slug = strtolower( str_replace( ' ', '', $theme->get( 'Name' ) ) );

				foreach ( $templates as $template ) {
					$template_path = '/woocommerce-store-catalog-pdf-download/' . $template;

					if ( file_exists( $stylesheet_dir . $template_path ) ) {
						echo wp_kses_post( $theme_slug . $template_path . '<br />' );
					}
				}
				?>
			</td>
		</tr>
	</tbody>
</table>
