<?php
/**
 * System Status Report.
 *
 * @since 2.2.0
 */

namespace KoiLab\WC_Store_Catalog_PDF_Download\Admin;

defined( 'ABSPATH' ) || exit;

/**
 * System Status Report class.
 */
class System_Status_Report {

	/**
	 * Init.
	 *
	 * @since 2.2.0
	 */
	public static function init() {
		add_action( 'woocommerce_system_status_report', array( __CLASS__, 'output_content' ) );
	}

	/**
	 * Output content.
	 *
	 * @since 2.2.0
	 */
	public static function output_content() {
		include_once __DIR__ . '/views/html-admin-system-status-report.php';
	}

	/**
	 * Outputs the HTML content for the boolean value.
	 *
	 * @since 2.2.0
	 *
	 * @param bool   $value The bool to format.
	 * @param string $text  Optional. Additional text to display. Default empty.
	 */
	public static function output_bool_html( bool $value, string $text = '' ) {
		printf(
			'<mark class="%1$s"><span class="dashicons dashicons-%2$s"></span>%3$s</mark>',
			esc_attr( $value ? 'yes' : 'error' ),
			esc_attr( $value ? 'yes' : 'no-alt' ),
			esc_html( $text ? " $text" : '' )
		);
	}
}
