<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use Dompdf\Dompdf;
use Dompdf\Options;
use KoiLab\WC_Store_Catalog_PDF_Download\Utilities\Template_Utils;

class WC_Store_Catalog_PDF_Download_Ajax {
	private static $_this;

	/**
	 * Accepted layouts.
	 *
	 * @since 2.1.0
	 *
	 * @var array
	 */
	private static $accepted_layouts = array( 'single', 'grid', 'list' );

	/**
	 * Init
	 *
	 * @since 1.0.0
	 * @return bool
	 */
	public function __construct() {
		self::$_this = $this;

		add_action( 'wp_ajax_wc_store_catalog_pdf_download_frontend_generate_pdf_ajax', array( $this, 'generate_pdf_ajax' ) );

		add_action( 'wp_ajax_nopriv_wc_store_catalog_pdf_download_frontend_generate_pdf_ajax', array( $this, 'generate_pdf_ajax' ) );

		add_action( 'wc_store_catalog_pdf_download_product_attr', 'wc_display_product_attributes' );
	}

	/**
	 * Get instance
	 *
	 * @since 1.0.0
	 * @return instance object
	 */
	public static function get_instance() {
		return self::$_this;
	}

	/**
	 * Get the download
	 *
	 * @since 1.0.0
	 * @return html
	 */
	public function generate_pdf_ajax() {
		$nonce = ( isset( $_POST['ajaxPDFDownloadNonce'] ) ? sanitize_text_field( wp_unslash( $_POST['ajaxPDFDownloadNonce'] ) ) : '' );

		if ( ! $nonce || ! wp_verify_nonce( $nonce, '_wc_store_catalog_pdf_download_nonce' ) ) {
			die( 'error' );
		}

		global $wc_posts, $layout, $is_single;

		if ( ! empty( $_POST['posts'] ) ) {
			$posts = json_decode( sanitize_text_field( wp_unslash( $_POST['posts'] ) ) );
			$posts = array_map( 'absint', $posts );

		} else {
			$posts = false;
		}

		$is_single = isset( $_POST['is_single'] ) ? sanitize_text_field( wp_unslash( $_POST['is_single'] ) ) : '';

		$layout = isset( $_POST['layout'] ) ? sanitize_text_field( wp_unslash( $_POST['layout'] ) ) : '';

		// single template trumps others
		$layout = ! empty( $is_single ) && $is_single === 'true' ? 'single' : $layout;

		$layout = in_array( $layout, self::$accepted_layouts, true ) ? $layout : '';

		// portrait, landscape
		$orientation = apply_filters( 'wc_store_catalog_pdf_download_orientation', 'portrait' );

		// 'letter', 'A4', 'legal'
		$size = apply_filters( 'wc_store_catalog_pdf_download_size', 'letter' );

		/**
		 * Filters the DOMPDF options.
		 *
		 * @since 2.2.0
		 *
		 * @param array $options An array with the DOMPDF options.
		 */
		$options = apply_filters(
			'wc_store_catalog_pdf_download_dompdf_options',
			array(
				'defaultFont'     => 'DejaVu Sans',
				'isRemoteEnabled' => true,
			)
		);

		$dompdf = new DOMPDF( new Options( $options ) );

		if ( has_action( 'woocommerce_store_catalog_pdf_download_dompdf_options' ) ) {
			wc_deprecated_hook( 'woocommerce_store_catalog_pdf_download_dompdf_options', '2.2.0', 'wc_store_catalog_pdf_download_dompdf_options' );

			/**
			 * Deprecated action hook.
			 *
			 * @since 1.10.26
			 * @deprecated 2.2.0
			 *
			 * @param DOMPDF $dompdf DOMPDF object.
			 */
			do_action( 'woocommerce_store_catalog_pdf_download_dompdf_options', $dompdf );
		}

		if ( $wc_posts = $posts ) {

			@set_time_limit( 0 );

			ob_start();

			Template_Utils::get_template( 'pdf-layout-header-html.php' );
			Template_Utils::get_template( "pdf-layout-{$layout}-html.php" );
			Template_Utils::get_template( 'pdf-layout-footer-html.php' );

			$html = ob_get_clean();

			// render pdf
			$dompdf->loadHtml( $html );
			$dompdf->setPaper( $size, $orientation );
			$dompdf->render();

			$upload_dir = wp_upload_dir();
			$pdf_path   = $upload_dir['basedir'] . '/woocommerce-store-catalog-pdf-download/';
			$pdf_url    = $upload_dir['baseurl'] . '/woocommerce-store-catalog-pdf-download/';
			$filename   = apply_filters( 'wc_store_catalog_pdf_download_filename', str_replace( ' ', '-', wp_specialchars_decode( get_bloginfo( 'name' ), ENT_QUOTES ) ) . '-' . __( 'Store-Catalog', 'woocommerce-store-catalog-pdf-download' ) . '-' . time() . '.pdf' );

			if ( ! is_dir( $pdf_path ) ) {
				mkdir( $pdf_path, 0777, true );
			}

			file_put_contents( $pdf_path . $filename, $dompdf->output() );

			echo $pdf_url . $filename;
			exit;
		}

		echo 'error';
		exit;
	}

	/**
	 * Gets the product meta template.
	 *
	 * @since 1.0.0
	 *
	 * @param WC_Product $product Product object.
	 * @return string
	 */
	public static function get_product_meta_template( $product ) {
		return Template_Utils::locate_template( 'pdf-layout-product-meta-html.php' );
	}

	/**
	 * Get placeholder image
	 *
	 * @since 1.0.0
	 * @param array $image_size
	 * @return string
	 */
	public static function get_placeholder_image( $image_size ) {
		if ( empty( $image_size ) ) {
			$image_size = array( 450, 450 );
		}

		return '<img src="' . wc_placeholder_img_src() . '" alt="' . __( 'Placeholder', 'woocommerce-store-catalog-pdf-download' ) . '" width="' . esc_attr( $image_size[0] ) . '" height="' . esc_attr( $image_size[1] ) . '" class="woocommerce-placeholder wp-post-image" />';
	}
}

new WC_Store_Catalog_PDF_Download_Ajax();
