(function( $ ) {
	'use strict';

	var openPreviewBtn = $('#26_section_group_li');
	var previewFrameContainer = $('#pdf-catalog-preview-frame-container');
	var previewFrame = $('#pdf-catalog-preview-frame');
	var previewFrameSpinner = $('#pdf-catalog-preview-spinner');
	var previewCategoryID = '#pdf-catalog-preview-category-id';
	var overlay = $('.pdf-catalog-preview-frame-overlay');

	previewFrame.on('load', function(){
        $(this).show();
        previewFrameSpinner.hide();
        previewFrame.show();
    });

	openPreviewBtn.on('click', function(e) {
		e.preventDefault();

		var category_id = $(previewCategoryID).val();
		var page_number = $('#pdf-catalog-preview-page-number').val();

		overlay.fadeIn();
		previewFrameContainer.fadeIn();
		previewFrameSpinner.show();

		var src = woocommerce_pdf_catalog_options.frontend_url + '?pdf-catalog=' + category_id;
		if(page_number) {
			src += '&page-number=' + page_number;
		}

		previewFrame.attr("src", src);

	});

	$(document).on('change', '#pdf-catalog-preview-category-id, #pdf-catalog-preview-page-number', function(e) {

		var category_id = $(previewCategoryID).val();
		var page_number = $('#pdf-catalog-preview-page-number').val();

		previewFrame.hide();
		previewFrameSpinner.show();

		var src = woocommerce_pdf_catalog_options.frontend_url + '?pdf-catalog=' + category_id;
		if(page_number) {
			src += '&page-number=' + page_number;
		}

		previewFrame.attr("src", src);
	});

	overlay.on('click', function(e) {
		e.preventDefault();
		previewFrameContainer.fadeOut();
		overlay.fadeOut();
	});


})( jQuery );